/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_WORD_FILTER_INTERFACE_H_
#define _SCE_WORD_FILTER_INTERFACE_H_

#include "np_toolkit_defines.h"

namespace sce { 
	namespace Toolkit {
		namespace NP {

	///	@brief
	///	The namespace containing word filter functionality.
	///
	///	The namespace containing word filter functionality.	
	namespace WordFilter {
		///	@brief
		///	The external interface to the word filter functionality.
		///
		///	The external interface to the word filter functionality.
		class Interface
		{
		public:
			///	@brief
			///	Filters or sanitizes a comment (or a singular word). 
 			///
			///	Filters or sanitizes a comment (or a singular word). 
			///
			/// There are two methods of filtering comments. The first method is to "censor" a comment, which results in an error code of #SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED
			/// being returned if inappropriate comment is discovered. To use this method, a value of <c>NULL</c> should be passed to the
			/// <c><i>sanitizedComment</i></c> parameter.
			///
			///	The second method is to "sanitize" a comment, which results in a sanitized version of the original comment being returned via a <c>Future</c> object.
			/// In the sanitized version of the comment inappropriate words are replaced with a '*'. To use this method, a <c>Future</c> object of the <c>WordFilterSanitized</c> type
			/// should be passed to the <c><i>sanitizedComment</i></c> parameter.
			///
			///	@param sanitizedComment				A <c>Future</c> object of the <c>WordFilterSanitized</c> type which will return the sanitized comment. Specifying <c>NULL</c> for this parameter indicates that the comment should be censored rather than sanitized.
			/// @param paramIn						The comment to filter or sanitize.	
			///
			///	@retval	SCE_TOOLKIT_NP_SUCCESS							The operation was successful. In the case of "censoring", this result indicates that the comment passed the censor. 
			/// @retval SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED			The operation was successful but the comment has been censored. 
			///	@retval	SCE_TOOLKIT_NP_WORD_FILTER_SLOT_FULL			The operation failed because the maximum number of simultaneous word filter operations allowed are currently being processed.
			///	@retval	SCE_TOOLKIT_NP_WORD_FILTER_NOT_INITIALISED		The operation failed because the word filter has not been initialized. 
			/// @retval other											An %NP Library Error Code.
			///
			/// @note
			///	It is possible to specify that this function should run asynchronously. To do this, use the <c><i>isAsync</i></c> member of the <c>WordFilterParam</c> object given as the <c><i>paramIn</i></c> argument.
			static int filterWord(sce::Toolkit::NP::Utilities::Future<WordFilterSanitized> *sanitizedComment, WordFilterParam* paramIn);
		};
	}

		}//end NP
	}//end Toolkit
}//end sce
#endif
